/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;
import java.util.Arrays;

public class Delay
extends UGen {
    public UGen.UGenInput audio = this.addAudio();
    public UGen.UGenInput delTime;
    public UGen.UGenInput delAmp;
    private float maxDelayTime;
    private double[] delayBuffer;
    private int delayBufferFrames;
    private int iBufferOut;
    private boolean feedBackOn;
    private boolean passAudioOn;

    public Delay() {
        this(0.25f, 0.5f, false, true);
    }

    public Delay(float f) {
        this(f, 0.5f, false, true);
    }

    public Delay(float f, float f2) {
        this(f, f2, false, true);
    }

    public Delay(float f, float f2, boolean bl) {
        this(f, f2, bl, true);
    }

    public Delay(float f, float f2, boolean bl, boolean bl2) {
        this.maxDelayTime = f;
        this.delTime = this.addControl(f);
        this.delAmp = this.addControl(f2);
        this.feedBackOn = bl;
        this.passAudioOn = bl2;
        this.iBufferOut = 0;
    }

    @Override
    protected void sampleRateChanged() {
        this.delayBufferFrames = (int)(this.maxDelayTime * this.sampleRate());
        this.delayBuffer = new double[this.delayBufferFrames * this.audio.channelCount()];
        this.iBufferOut = 0;
    }

    @Override
    public void setAudioChannelCount(int n) {
        super.setAudioChannelCount(n);
        this.delayBufferFrames = (int)(this.maxDelayTime * this.sampleRate());
        this.delayBuffer = new double[this.delayBufferFrames * this.audio.channelCount()];
        this.iBufferOut = 0;
    }

    public void setDelTime(float f) {
        this.delTime.setLastValue(f);
    }

    public void setDelAmp(float f) {
        this.delAmp.setLastValue(f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.delayBuffer == null || this.delayBuffer.length == 0) {
            Arrays.fill(fArray, 0.0f);
            return;
        }
        int n = (int)(this.delTime.getLastValue() * this.sampleRate());
        for (int i = 0; i < fArray.length; ++i) {
            float f = this.audio.getLastValues()[i];
            int n2 = this.iBufferOut * fArray.length + i;
            float f2 = this.delAmp.getLastValue() * (float)this.delayBuffer[n2];
            this.delayBuffer[n2] = 0.0;
            int n3 = (this.iBufferOut + n) % this.delayBufferFrames;
            int n4 = n3 * fArray.length + i;
            this.delayBuffer[n4] = f;
            if (this.feedBackOn) {
                int n5 = n4;
                this.delayBuffer[n5] = this.delayBuffer[n5] + (double)f2;
            }
            if (this.passAudioOn) {
                f2 += f;
            }
            fArray[i] = f2;
        }
        this.iBufferOut = (this.iBufferOut + 1) % this.delayBufferFrames;
    }
}

